/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.sonarlint.core.client.api.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;

public class TextSearchIndex<T> {
    private static final String SPLIT_PATTERN = "\\W";
    private TreeMap<String, List<DictEntry>> wordToObj;
    private Set<T> indexedObjs;
    private Map<T, Integer> objToWordFrequency;

    public TextSearchIndex() {
        this.clear();
    }

    public void index(T obj, String text) {
        if (this.indexedObjs.contains(obj)) {
            throw new IllegalArgumentException("Already indexed");
        }
        this.indexedObjs.add(obj);
        List<String> terms = TextSearchIndex.tokenize(text);
        int i = 0;
        for (String s : terms) {
            this.addToDictionary(s, i, obj);
            ++i;
        }
    }

    public List<T> search(String query) {
        List<DictEntry> matched;
        List<String> terms = TextSearchIndex.tokenize(query);
        if (terms.isEmpty()) {
            return Collections.emptyList();
        }
        Iterator<String> it = terms.iterator();
        String first = it.next();
        if (terms.size() > 1) {
            List<DictEntry> entries;
            matched = this.searchTerm(first, true);
            while (it.hasNext() && !(matched = this.matchPositional(matched, entries = this.searchTerm(it.next(), true), 1)).isEmpty()) {
            }
        } else {
            matched = this.searchTerm(first, false);
        }
        return this.prepareResult(matched);
    }

    /*
     * WARNING - void declaration
     */
    private List<T> prepareResult(List<DictEntry> entries) {
        HashMap projectToScore = new HashMap();
        for (DictEntry dictEntry : entries) {
            void var5_10;
            Double d = (Double)projectToScore.get(dictEntry.obj);
            if (d == null) {
                Double d2 = 0.0;
            }
            Double d3 = var5_10.doubleValue() + 1.0 / (double)this.objToWordFrequency.get(dictEntry.obj).intValue();
            projectToScore.put(dictEntry.obj, d3);
        }
        LinkedList<ScorableObject> scoredProjects = new LinkedList<ScorableObject>();
        for (Map.Entry entry : projectToScore.entrySet()) {
            scoredProjects.add(new ScorableObject(entry.getKey(), (Double)entry.getValue()));
        }
        Collections.sort(scoredProjects, new Comparator<ScorableObject>(){

            @Override
            public int compare(ScorableObject o1, ScorableObject o2) {
                double score = o2.score - o1.score;
                if (score > 0.0) {
                    return 1;
                }
                if (score < 0.0) {
                    return -1;
                }
                return 0;
            }
        });
        LinkedList linkedList = new LinkedList();
        for (ScorableObject p : scoredProjects) {
            linkedList.add(p.obj);
        }
        return linkedList;
    }

    private List<DictEntry> searchTerm(String term, boolean fullMatchOnly) {
        List<Object> entries = new LinkedList();
        if (fullMatchOnly) {
            entries = this.wordToObj.get(term);
            return entries != null ? entries : Collections.emptyList();
        }
        SortedMap<String, List<DictEntry>> tailMap = this.wordToObj.tailMap(term);
        for (Map.Entry<String, List<DictEntry>> e : tailMap.entrySet()) {
            if (!e.getKey().startsWith(term)) break;
            entries.addAll(e.getValue());
        }
        return entries;
    }

    public void clear() {
        this.indexedObjs = new HashSet<T>();
        this.wordToObj = new TreeMap();
        this.objToWordFrequency = new HashMap<T, Integer>();
    }

    public Set<String> getTokens() {
        return this.wordToObj.keySet();
    }

    private void addToDictionary(String token, int tokenIndex, T obj) {
        List<DictEntry> projects = this.wordToObj.get(token);
        Integer count = this.objToWordFrequency.get(obj);
        if (projects == null) {
            projects = new LinkedList<DictEntry>();
            this.wordToObj.put(token, projects);
        }
        if (count == null) {
            count = 0;
        }
        Integer n = count;
        Integer n2 = count = Integer.valueOf(count + 1);
        projects.add(new DictEntry(obj, tokenIndex));
        this.objToWordFrequency.put(obj, count);
    }

    private static List<String> tokenize(String text) {
        String[] split = text.split(SPLIT_PATTERN);
        ArrayList<String> terms = new ArrayList<String>(split.length);
        for (String s : split) {
            if (s.isEmpty()) continue;
            terms.add(s.toLowerCase(Locale.ENGLISH));
        }
        return terms;
    }

    private List<DictEntry> matchPositional(List<DictEntry> results1, List<DictEntry> results2, int maxDistance) {
        LinkedList<DictEntry> matches = new LinkedList<DictEntry>();
        for (DictEntry e1 : results1) {
            for (DictEntry e2 : results2) {
                int dist;
                if (!e1.obj.equals(e2.obj) || (dist = e2.tokenIndex - e1.tokenIndex) <= 0 || dist > maxDistance) continue;
                matches.add(e2);
            }
        }
        return matches;
    }

    private class DictEntry {
        T obj;
        int tokenIndex;

        public DictEntry(T obj, int tokenIndex) {
            this.obj = obj;
            this.tokenIndex = tokenIndex;
        }
    }

    private class ScorableObject {
        double score;
        T obj;

        public ScorableObject(T obj, double score) {
            this.score = score;
            this.obj = obj;
        }
    }
}

